#ifndef I2CUnitH
#define I2CUnitH
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Dialogs.hpp>
//---------------------------------------------------------------------------
class TI2C
{

private:

HINSTANCE hLib;
bool port_is_open;                                                              // port open = 1
bool dontcareackn;                                                              // if 1 no exception if slave is not responding
typedef bool _stdcall (*OPENCOMPtr)(String A); OPENCOMPtr OPENCOM;
typedef void _stdcall (*CLOSECOMPtr)(void);    CLOSECOMPtr CLOSECOM;
typedef void _stdcall (*DTRPtr)(int B);        DTRPtr DTR;
typedef void _stdcall (*RTSPtr)(int B);        RTSPtr RTS;
typedef bool _stdcall (*CTSPtr)(void);         CTSPtr CTS;
typedef bool _stdcall (*DSRPtr)(void);         DSRPtr DSR;

public:
TI2C();                                                                         // empty Konstruktor

bool OpenPort(String Port);                                                     // opens port. Ex. for String: "COM2:2400,n,8,1"
void ClosePort(void);                                                           // close open port
void SCL(int i);                                                                // set/unset scl
void SDA(int i);                                                                // set/unset sda
bool SDA_in(void);                                                              // returns sda
bool INT(void);                                                                 // return INT
void Init(void);                                                                // inits IC bus
void Start(void);                                                               // send start cond.
void Stop(void);                                                                // send stop cond
void Ack(void);                                                                 // send ackn.
void NoAck(void);                                                               // send nackn.
bool SendSlaveAdress(unsigned char Addr);                                       // send adress of slave
unsigned char ReadByte(void);                                                   // reads byte from slave
bool SendByte(unsigned char Wert);                                              // sends byte to slave
void Set_DontCareAckn(bool dontcareackn_rhs);                                   // sets flag for no ackn exception
bool Get_DontCareAckn(void);                                                    // returns flag for no ackn exception
};
//---------------------------------------------------------------------------






#endif
