#pragma hdrstop
#include "I2CUnit.cpp"
#include "PCF8574AUnit.h"


//---------------------------------------------------------------------------
TPCF8574A::TPCF8574A(){have_adress = false; have_i2c = false;};
//---------------------------------------------------------------------------
TPCF8574A::TPCF8574A(TI2C* I2C_rhs, unsigned char address_rhs){I2C = I2C_rhs; address = address_rhs;have_adress = true; have_i2c = true;};
//---------------------------------------------------------------------------
void TPCF8574A::Set_I2C(TI2C* I2C_rhs){this->I2C = I2C_rhs; have_i2c = true;};
//---------------------------------------------------------------------------
class TI2C* TPCF8574A::Get_I2C(void){return this->I2C;};
//---------------------------------------------------------------------------
void TPCF8574A::Set_Address(unsigned char address_rhs){this->address = address_rhs; have_adress = true;};
//---------------------------------------------------------------------------
unsigned char TPCF8574A::Get_Adress(void){return this->address;};
//---------------------------------------------------------------------------
void TPCF8574A::WriteByte(unsigned char byte_rhs)
{
if (!have_adress || !have_i2c) return;

I2C->Start();
I2C->SendSlaveAdress(0x70 | (this->address << 1));
I2C->SendByte(byte_rhs);
I2C->Stop();

return;
};
//---------------------------------------------------------------------------
unsigned char TPCF8574A::ReadByte(void)
{
unsigned char response = 0x00;
if (!have_adress || !have_i2c) return response;

I2C->Start();
I2C->SendSlaveAdress(0x71 | (this->address << 1));
response = I2C->ReadByte();
I2C->NoAck();
I2C->Stop();

return response;
};
//---------------------------------------------------------------------------
void TPCF8574A::Set_Bit(unsigned char num, bool status)
{
if (!have_adress || !have_i2c) return ;

unsigned char statebyte = this->ReadByte();
if (status)
this->WriteByte(statebyte | (0x01 << num));
else
this->WriteByte(statebyte & (~(0x01 << num)));
return;
};
//---------------------------------------------------------------------------
bool TPCF8574A::Get_Bit(unsigned char num)
{
if (!have_adress || !have_i2c) return 0x00;
return (this->ReadByte() & (0x01 << num));
};
//---------------------------------------------------------------------------











#pragma package(smart_init)
