#ifndef PCF8574AUnitH
#define PCF8574AUnitH
//---------------------------------------------------------------------------
class TPCF8574A
{
private:

class TI2C* I2C;											// Zeiger auf I2C-Port-Modul
unsigned char address;										// eigene Adresse
bool have_adress, have_i2c;									// Kontrollparameter: Beides muss bergeben worden sein

public:

TPCF8574A();												// leerer Konstruktor
TPCF8574A(TI2C* I2C_rhs, unsigned char address_rhs);		// Konstruktor mit gleichzeitiger bergabe von I2C-Port-Modul-Adresse und PCF8574A-eigener Adresse
void Set_I2C(TI2C* I2C_rhs);								// Adresse des I2C-Port-Moduls setzen
class TI2C* Get_I2C(void);									// Adresse des I2C-Port-Moduls lesen
void Set_Address(unsigned char address_rhs);				// PCF8574A-eigene Adresse bergeben
unsigned char Get_Adress(void);								// PCF8574A-eigene Adresse lesen
void WriteByte(unsigned char byte_rhs);						// Byte am PCF8574A ausgeben
unsigned char ReadByte(void);								// Byte am PCF8574A lesen (ev. vorher Bits auf 1 setzen)
void Set_Bit(unsigned char num, bool status);				// einzelnes Bit an Stelle "num" auf "status" setzen
bool Get_Bit(unsigned char num);							// einzelnes Bit an Stelle "num" abfragen
};
//---------------------------------------------------------------------------
#endif
