#pragma hdrstop
#include "I2CUnit.h"
//---------------------------------------------------------------------------
TI2C::TI2C()
{
hLib = LoadLibrary("PORT.DLL");

if (hLib == NULL) MessageDlg("Load of Library PORT.DLL failed.", mtInformation, TMsgDlgButtons() << mbOK, 0);
else
{
 OPENCOM = (OPENCOMPtr) GetProcAddress(hLib, "OPENCOM");
 CLOSECOM = (CLOSECOMPtr) GetProcAddress(hLib, "CLOSECOM");
 DTR = (DTRPtr) GetProcAddress(hLib, "DTR");
 RTS = (RTSPtr) GetProcAddress(hLib, "RTS");
 CTS = (CTSPtr) GetProcAddress(hLib, "CTS");
 DSR = (DSRPtr) GetProcAddress(hLib, "DSR");
};
port_is_open = false;
dontcareackn = false;
}
//---------------------------------------------------------------------------
bool TI2C::OpenPort(String PortString)
{
try
{
 port_is_open = OPENCOM(PortString);
 return port_is_open;
}
catch (...)
{
 MessageDlg("Fehler beim Port-ffnen\n",  mtInformation, TMsgDlgButtons() << mbOK, 0);
 return false;
}
}
//---------------------------------------------------------------------------
void TI2C::ClosePort(void)
{
if (port_is_open)
CLOSECOM();
port_is_open = false;
return;
}
//---------------------------------------------------------------------------
// I2C Taktleitung an RTS Leitung der RS-232 schalten
void TI2C::SCL(int i)
{
RTS(i);
return;
}
//---------------------------------------------------------------------------
// I2C Datenleitung an DTR Leitung der RS-232 schalten
void TI2C::SDA(int i)
{
DTR(i);
return;
}
//---------------------------------------------------------------------------
// Rcklesen der SDA-Leitung am DSR der RS-232
bool TI2C::SDA_in(void)
{
return DSR();
}
//---------------------------------------------------------------------------
// Auslesen des INT am CTS der RS-232
bool TI2C::INT(void)
{
return CTS();
}
//---------------------------------------------------------------------------
// Initialisieren des I2C Busses SDA=High, SCL = High
void TI2C::Init()
{
SDA(1);
SCL(1);
return;
}
//---------------------------------------------------------------------------
// Start der I2C bertragung. Erst SDA dann SCL Low
void TI2C::Start()
{
SDA(1);
SCL(1);
SDA(0);
SCL(0);
return;
}
//---------------------------------------------------------------------------
// Stoppen der I2C bertragung durch SDA dann SCL High
void TI2C::Stop()
{
SDA(0);
SCL(1);
SDA(1);
return;
}
//---------------------------------------------------------------------------
void TI2C::Ack(void)
{
SCL(0);
SDA(0);
SCL(1);
SCL(0);
return;
}
//---------------------------------------------------------------------------
// No Ack -> Byte empfangen - Nichts senden
void TI2C::NoAck(void)
{
SCL(0);
SDA(1);
SCL(1);
SCL(0);
return;
}
//---------------------------------------------------------------------------
// Slave adressieren
bool TI2C::SendSlaveAdress(unsigned char Addr)
{
unsigned char BytePos = 128;
// Die 8 Bits der Slaveadresse werden nacheinander auf die SDA-Leitung gelegt und
// jeweils mit einem Impuls auf der SCL-Leitung besttigt.
// nach dem Stop-Befehl quittiert der Slave den Empfang der Daten
for (int count = 0; count < 8; count++)
{
 if ((Addr & BytePos) == 0)
 SDA(0);
 else
 SDA(1);
 SCL(1);
 for (int i = 0; i< 5;i++);
 SCL(0);
 BytePos /= 2;
}

// SDA auf High Pegel setzen. Slave zieht auf Masse
SDA(1);

// 9. Impuls
SCL(1);
// Der Slave antwortet darauf mit neg. Flanke an SDA

if (SDA_in())
{
 SCL(0);
 if (!dontcareackn)
 throw new Exception("Kein Slave mit Addr. 0x" + IntToHex((byte)Addr,2) + " vorhanden.");
}
else
{
 SCL(0);
 return true;
}

return false;
}
//---------------------------------------------------------------------------
// Werte von Slave auslesen
// Master sendet dazu 8 Impulse auf SCL und erhlt high und low Pegel auf SDA.
unsigned char TI2C::ReadByte(void)
{
unsigned char BytePos = 128;
unsigned char Wert = 0;
SDA(1);
SCL(0);

for (int count = 0; count < 8; count++)
{
 SCL(1);
for (int i = 0; i< 5;i++);
 if (SDA_in()) Wert += BytePos;
 SCL(0);
 BytePos /= 2;
}
return Wert;
};
//---------------------------------------------------------------------------
// Wert zu Slave senden
bool TI2C::SendByte(unsigned char Wert)
{
// Die Datenbits werden nacheinander auf SDA gelegt und mit SCL besttigt
// nach dem neunten Impuls quittierung durch Slave

unsigned char BytePos = 128;

for (int count = 0; count < 8; count++)
{
 if ((Wert & BytePos) == 0)
 SDA(0);
 else
 SDA(1);
 SCL(1);
 for (int i = 0; i< 5;i++);
 SCL(0);
 BytePos /= 2;
}

SDA(1);
SCL(1);

// Slave antwortet mit neg. Flanke auf Daten
if (SDA_in() )
{
 SCL(0);
 if (!dontcareackn)
 throw new Exception("Kein Ack von Slave");
}
else
{
 SCL(0);
 return true;
}
return false;
}
//---------------------------------------------------------------------------
void TI2C::Set_DontCareAckn(bool dontcareackn_rhs)
{
this->dontcareackn = dontcareackn_rhs;
return;
};
//---------------------------------------------------------------------------
bool TI2C::Get_DontCareAckn(void)
{
return this->dontcareackn;
};
//---------------------------------------------------------------------------
#pragma package(smart_init)
