'**************************************
'
' C-Control/BASIC       8574AUS.BAS
'
' Aufgabe:
'
' - Ansteuerung eines PCF8574
'
' Das Programm lscht zuerst alle Ausgnge, und schaltet sie dann der Reihe nach ein
' und wieder aus,  wartet dann eine Sekunde und das ganze beginnt von neuem.
'
'**************************************
' --- Definitionen --------------------

define SDA port[7]
define SCL port[8]
define Daten byte
define Komma byte
define Zaehler byte
define N byte

' --- Programmoperationen -------------

SDA = ON
SCL = ON

#Loop
    gosub Start
    Daten = 66    '1. Adresse PFC 8574 beim schreiben
    gosub I2C_Write
    daten = 0   'alle ausgnge auf low setzen
    gosub I2C_Write
    daten = &B00000001  'ausgang 1 auf high setzen  Dezimal 1
    gosub I2C_Write
    daten = &B00000010  'ausgang 2 auf high setzen  Dezimal 2
    gosub I2C_Write
    daten = &B00000100  'ausgang 3 auf high setzen  Dezimal 4
    gosub I2C_Write
    daten = &B00001000  'ausgang 4 auf high setzen  Dezimal 8
    gosub I2C_Write
    daten = &B00010000  'ausgang 5 auf high setzen  Dezimal 16
    gosub I2C_Write
    daten = &B00100000  'ausgang 6 auf high setzen  Dezimal 32
    gosub I2C_Write
    daten = &B01000000  'ausgang 7 auf high setzen  Dezimal 64
    gosub I2C_Write
    daten = &B10000000  'ausgang 8 auf high setzen  Dezimal 128
    gosub I2C_Write
    gosub Stop   'Leitung wieder freigeben
    pause 50
goto loop

#Start
  SDA = OFF
  SCL = OFF
  return

#Stop
  SDA = OFF
  SCL = ON
  SDA = ON
  return

#I2C_WRITE
  for N = 1 to 8
    sda = off
    if (Daten AND 128) = 128 then SDA = ON
    pulse SCL
    Daten = Daten shl 1 '1 Bit nach links
  next
  pulse SCL             ' 9. Impuls  Ack vom IC
  return


#Ack
  SDA = 0
  pulse SCL
  return

#NoAck
  SDA = 1
  pulse SCL
  return

end

