unit horter_seriell;
{
 I2C Hardware interface for Horter & Kalb I2C-Interfaces
 based on Port.DLL from B.Kainka
 (C) 2006 Thomas Dreler
 }
interface
  Function  PortOpen(Port:String):Boolean;
  Procedure PortClose;
  Procedure  SCL(State:Boolean);
  Procedure  SDA(State:Boolean);
  Function  GetSDA:Boolean;
  Function  GetINT:Boolean;
  Function  GetSCL:Boolean;
  Function  DeviceCheck:Boolean;
  Function  DeviceOpen:Boolean;
implementation
uses portinc;
const Parameter=':1200,N,8,1';
      high = true;
      low = false;
var PortState:Boolean;
    SCLState:Boolean;

// ------------------------------------------------------------------
// Hardware specific parts

Procedure SCL(state:Boolean);
//SCL auf der RTS-Leitung am COM-Port
var b:word;
Begin
  if state then b:=1 else b:=0;
  RTS(b);
  SCLState:=state;
End;

Procedure SDA(state:Boolean);
//Die Daten werden ber DTR am COM-Port geschrieben
var b:word;
Begin
  if state then b:=1 else b:=0;
  DTR(b);
End;

Function GetSCL():Boolean;
//faked
Begin
  Result :=SCLState;
End;

Function GetSDA():Boolean;
//Die SDA-Leitung wird ber DSR am COM-Port wieder zurckgelesen
Begin
  Result := (DSR()=1);
End;

Function GetINT:Boolean;
//Die INT-Leitung der Eingabekarten wird ber CTS am COM-Port berwacht
Begin
  Result := (CTS()=1);
End;
// check openflag
Function DeviceCheck:Boolean;
begin
  SDA(high);
  SCL(high);
  if (GetSDA) then Result:=true else Result:=false;
end;

// check openflag
Function DeviceOpen:Boolean;
begin
  Result:=PortState;
end;

// Schnittstelle ffnen und Leitungen initialiseren
Function PortOpen(Port:String):Boolean;
var p:string;
Begin
  Result := false;
  Portstate:=false;
  p:=Port+Parameter;
  If (OPENCOM(PCHAR(p))<>0) Then
  Begin
    if DeviceCheck() then  PortState:=true;
    Result := PortState;
  End;
End;

// Schnittstelle freigeben
Procedure PortClose;
Begin
  CLOSECOM();
  PortState:=false;
End;

end.
