unit i2c_base;
{
 i2c Base Library for Horter & Kalb I2C-Interfaces
 based on Port.DLL from B.Kainka and
 Demo Program I2C-LM75-Test.XLS from Horter & Kalb
 (C) 2006 Thomas Dreler
 }
interface
  Function  I2Copen(Port:String):Boolean;
  Procedure I2CClose;
  Procedure I2CStart;
  Procedure I2CStop;
  Procedure I2CInit;
  Function  I2Cout(b:Byte):Boolean;
  Function  I2Cin:Byte;
  Procedure I2CAck;
  Procedure I2CNoAck;

implementation
//Hardware Unit: Horter Serial PC Interface
uses horter_seriell;

Const
  high = true;
  low = false;

// ---------------
// I2C-Protocoll
//----------------

// Schnittstelle oeffnen und testen
Function I2Copen(Port:String):Boolean;
Begin
  Result:=PortOpen(Port);
end;

Procedure I2CInit;
Begin
    //Ruhezustand SDA=high und SCL=high
	  SDA (high);
	  SCL (high);
End;

// Sendet ein Startbit zum Slave
Procedure I2CStart;
Begin
  // Wenn CLK high ist, wechselt SDA von high nach low
  SDA(high);
  SCL(high);
  SDA(low);
  SCL(low);
End;

// Sendet ein Stopbit zum Slave
Procedure I2CStop;
Begin
  // Wenn CLK high ist, wechselt SDA von low nach high
  SDA(low);
  SCL(high);
  SDA(high);
End;

Procedure I2CAck;
begin
//ACKNOWLEDGE => Byte empfangen weitere Daten senden
SDA (low);
SCL (high);
SCL (low);
SDA (high);
End;


Procedure I2CNoAck;
begin
//NO ACKNOWLEDGE => Byte empfangen - Keine weiteren Daten senden
SDA (high);
SCL (high);
SCL (low);
End;

// Schnittstelle schliessen
Procedure I2Cclose;
Begin
  //i2cNoack;
  //I2CStop;
  PortClose;
End;

// Sendet ein Byte zum Slave
// b1 ist das Byte, welches zum Slave gesendet wird
Function I2Cout(b:Byte):Boolean;
Var i:Integer; Bit:Byte;
Begin
  Result := false;
  Bit := $80;
  For i := 1 to 8 do Begin
    If (b and Bit) = Bit Then
      SDA(high)
    Else
      SDA(low);

    SCL(high);
    SCL(low);
    //SDA(high);
    Bit := Bit div 2;
  End;
  {Acknowledge empfangen ->
  SDA high setzen - wird vom Slave heruntergezogen
  9. Impuls}
  SDA(high);
  SCL(high);
  //Slave antwortet mit neg. Flanke
  Result := not GetSDA;
  SCL(low);
  SDA(high);
End;

// Empfngt ein Byte vom Slave
// Ack ist das zum Slave gesendete Acknowledge Bit.
// Ist bei einigen Bausteinen notwendig um einen
// Autoincrement Modus zu beenden.
Function I2Cin:Byte;
Var i:Integer; b1:Byte;
Begin
  Result := 0;
  SDA(high);
  b1 := $00;
  For i := 1 to 8 do Begin
    b1 := b1 * 2;
    SCL(high);
    If GetSDA = high Then b1 := b1 or $01;
    SCL(low);
  End;
  Result := b1;
End;
end.
