unit i2cmain;
 {
 I2C-Testprogramm for Horter & Kalb I2C-Interfaces
 based on Port.DLL from B.Kainka and
 Demo Program I2C-LM75-Test.XLS from Horter & Kalb
 (C) 2006 Thomas Dreler
 }
interface

uses Windows, Classes, Graphics, Forms, Controls, Menus,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls, ImgList, StdActns,
  ActnList, ToolWin,Sysutils;

type
  TSDIAppForm = class(TForm)
    StatusBar: TStatusBar;
    btOpen: TButton;
    cbPort: TComboBox;
    cbAdresse: TComboBox;
    Label1: TLabel;
    btLM75_Lesen: TButton;
    eLM75_Temp: TEdit;
    eLM75_SP: TEdit;
    btLM75_SPGet: TButton;
    btLM75_SPSet: TButton;
    eLM75_Hyst: TEdit;
    btLM75_HyGet: TButton;
    btLM75_HySet: TButton;
    Label2: TLabel;
    btClose: TButton;
    Label3: TLabel;
    procedure btLM75_HySetClick(Sender: TObject);
    procedure btLM75_SPSetClick(Sender: TObject);
    procedure btCloseClick(Sender: TObject);
    procedure btLM75_HyGetClick(Sender: TObject);
    procedure btLM75_SPGetClick(Sender: TObject);
    procedure btLM75_LesenClick(Sender: TObject);
    procedure btOpenClick(Sender: TObject);
    procedure FileExit1Execute(Sender: TObject);
    procedure HelpAbout1Execute(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  SDIAppForm: TSDIAppForm;


implementation

uses about,i2c_base,lm75;

{$R *.dfm}


procedure TSDIAppForm.FileExit1Execute(Sender: TObject);
begin
  Close;
end;

procedure TSDIAppForm.HelpAbout1Execute(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TSDIAppForm.btOpenClick(Sender: TObject);
begin
  If btOpen.Caption = 'Port oeffnen' Then
  begin
    //Serielle Schnittstelle ffnen
    If not(i2copen(cbPort.Text)) Then

        Application.MessageBox (PChar('Fehler, kann ' + cbPort.Text + ' nicht ffnen'),'I2C-Test',MB_RETRYCANCEL)


    Else
        begin
            //I2C-Bus initialisieren
            i2cInit;
            i2cStart;
            i2cNoAck;
            i2cStop;
            //Buttons einbelnden
            btOpen.Caption := 'Close';
            btLM75_Lesen.Visible := True;
            btLM75_SPset.Visible := True;
            btLM75_Hyset.Visible := True;
            btLM75_SPget.Visible := True;
            btLM75_Hyget.Visible := True;
            //btLM75_Konfget.Visible = True
            //btLM75_Konfset.Visible = True

    End;
  end
  else
  begin
    //Serielle Schnittstelle schlieen
    i2cclose;
    //Buttons ausbelnden
    btOpen.Caption := 'Port oeffnen';
    btLM75_Lesen.Visible := False;
    btLM75_SPset.Visible := False;
    btLM75_SPget.Visible := False;
    btLM75_Hyset.Visible := False;
    btLM75_Hyget.Visible := False;
    //btCbLM75_Konfget.Visible = False
    //btCbLM75_Konfset.Visible = False
  End;
end;
procedure TSDIAppForm.btLM75_LesenClick(Sender: TObject);
var Temperatur: double;
    b:byte;
begin
//Temperatur vom LM75 lesen


i2cInit;
i2cStart;
b:=(Strtoint(cbAdresse.Text)and 255);
If (i2cOut(b)) Then
begin
    i2cOut(0);   //Register  auf Temperatur setzen
    i2cStop;
    i2cStart;
    i2cOut(b + 1); //Bus-Adresse des LM75 schreiben
    Temperatur := i2cLM75_in;   //Temperatur auslesen
    eLM75_Temp.Text := Formatfloat('##,##0.00',Temperatur);
End
else
  Application.MessageBox (PChar('Fehler, kann Gert an Adresse' + cbAdresse.Text + ' nicht ffnen'),'I2C-Test',MB_OK);
i2cAck;
i2cStop;
end;

procedure TSDIAppForm.btLM75_SPGetClick(Sender: TObject);
var Temperatur: double;
    b:byte;
begin
//Schaltpunkt vom LM75 lesen
i2cInit;
i2cStart;
b:=(Strtoint(cbAdresse.Text)and 255);
If (i2cOut(b)) Then
begin
    i2cOut(3);   //Register  auf Schaltpunkt setzen
    i2cStop;
    i2cStart;
    i2cOut(b + 1); //Bus-Adresse des LM75 schreiben
    Temperatur := i2cLM75_in;   //Schaltpunkt auslesen
    eLM75_SP.Text := Formatfloat('##,##0.00',Temperatur);
End
else
  Application.MessageBox (PChar('Fehler, kann Gert an Adresse' + cbAdresse.Text + ' nicht ffnen'),'I2C-Test',MB_OK);
i2cAck;
i2cStop;

end;

procedure TSDIAppForm.btLM75_HyGetClick(Sender: TObject);
var Temperatur: double;
    b:byte;
begin
//Schaltpunkt vom LM75 lesen
i2cInit;
i2cStart;
b:=(Strtoint(cbAdresse.Text)and 255);
If (i2cOut(b)) Then
begin
    i2cOut(2);   //Register  auf Hystere setzen
    i2cStop;
    i2cStart;
    i2cOut(b + 1); //Bus-Adresse des LM75 schreiben
    Temperatur := i2cLM75_in;   //Hysterese auslesen
    eLM75_Hyst.Text := Formatfloat('##,##0.00',Temperatur);
End
else
  Application.MessageBox (PChar('Fehler, kann Gert an Adresse' + cbAdresse.Text + ' nicht ffnen'),'I2C-Test',MB_OK);
i2cAck;
i2cStop;


end;

procedure TSDIAppForm.btCloseClick(Sender: TObject);
begin
    i2cclose;
    Application.Terminate;
end;

procedure TSDIAppForm.btLM75_SPSetClick(Sender: TObject);
var b:byte;
    w:double;
begin
    i2cInit;
    i2cStart;
    b:=(Strtoint(cbAdresse.Text)and 255);
    If (i2cOut(b)) Then
    begin
      i2cOut (3);                              //Register  auf "Tos" setzen
      w:=strtofloat(eLM75_SP.Text);
      i2cLM75_out (w); //Wert schreiben
    End;
    i2cStop;
end;

procedure TSDIAppForm.btLM75_HySetClick(Sender: TObject);

var b:byte;
    w:double;

begin
    i2cInit;
    i2cStart;
    b:=(Strtoint(cbAdresse.Text)and 255);
    If (i2cOut(b)) Then
    begin
      i2cOut (2);                              //Register  auf "Hyst" setzen
      w:=strtofloat(eLM75_Hyst.Text);
      i2cLM75_out (w); //Wert schreiben
    End;
    i2cStop;
end;


end.
