unit lm75;
 {
 LM75 Library extension for Horter & Kalb I2C-Interfaces
 based on Port.DLL from B.Kainka and
 Demo Program I2C-LM75-Test.XLS from Horter & Kalb
 (C) 2006 Thomas Dreler
 }
interface
    Function i2cLM75_in:double;
    Procedure i2cLM75_out(t:double);

implementation

uses i2c_base;

Function i2cLM75_in:double; //Liest einen Wert (2 Byte) vom LM75 Temperatursensor
var Byte1, Byte2 :byte;
  Wert:double;

begin
    Byte1 := i2cIn;                 //1. Byte Wert vom LM75 lesen
    i2cAck;
    Byte2 := i2cIn;                 //2. Byte lesen
    i2cNoAck;

    If (Byte1 And 128) = 0 Then
        Wert := Byte1              //Temperatur Vorkomma >= 0C
    Else
        Wert := Byte1 - 255;        //Temperatur Vorkomma < 0C

    If ((Byte2 And 128) <> 0) Then
        Wert := Wert + 0.5;

    i2cLM75_in := Wert;

End;
Procedure i2cLM75_out(t:double); //Schreibt einen Wert (2 Byte) vom LM75 Temperatursensor
var VK, NK: double;
    var b :byte;
begin
VK := int(t);
NK := t - VK;
b:=trunc(VK) and 255;
If (VK >= 0) Then
    i2cOut( b)
Else
    i2cOut (255 + b);

If (NK >= 0.5) Then                     //Nachkommawert schreiben
    i2cOut(128)                          // xx,5 schreiben
Else
    i2cOut(0);                            // xx,0 schreiben

End;
end.
