/*
 * Created by SharpDevelop.
 * User: VeithC
 * Date: 04.10.2005
 * Time: 08:31
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */

using System;
using System.Drawing;
using System.Windows.Forms;
using System.Runtime.InteropServices;



namespace I2C
{

	/// <summary>
	/// Make Connection between Port.dll and MainForm.
	/// </summary>
	public class i2c_connection
	{		

		[DllImport("port.dll")]
		private static extern bool OPENCOM(string A);
		
		[DllImport("port.dll")]
		private static extern void CLOSECOM();
		
		[DllImport("port.dll")]
		private static extern void DTR(int B);
		
		[DllImport("port.dll")]
		private static extern void RTS(int B);
		
		[DllImport("port.dll")]
		private static extern bool CTS();

		[DllImport("port.dll")]
		private static extern bool DSR();
		
		public i2c_connection()
		{
		}

		public bool I2C_Open(string Port)
		{
			try
			{
				OPENCOM( Port + ":1200,n,8,1");
				return true;
			}
			catch (Exception ex)
			{
				MessageBox.Show("Com-Port " + Port + " nicht vorhanden\n" + ex.Message, "Fehler", MessageBoxButtons.OK, MessageBoxIcon.Hand, MessageBoxDefaultButton.Button1);
				return false;
			}
		}
		
		public void I2C_Close()
		{
			CLOSECOM();
		}
		
		// I2C Taktleitung an RTS Leitung der RS-232 schalten
		public void SCL(int i)
		{
			RTS(i);
		}
		
		// I2C Datenleitung an DTR Leitung der RS-232 schalten
		public void SDA(int i)
		{
			DTR(i);
		}
		
		// Rcklesen der SDA-Leitung am DSR der RS-232
		public bool SDA_in()
		{
			if (DSR()) 
			{
				return true;	
			}
			else
			{
				return false;
			}
		}
		
		// Auslesen des INT am CTS der RS-232
		public bool I2C_INT()
		{
			if (CTS())
			{
				return true;
			}
			else
			{
				return false;
			}
		}

		// Initialisieren des I2C Busses SDA=High, SCL = High
		public bool I2C_Init()
		{
			SDA(1);
			SCL(1);
			return SDA_in();
		}
		
		// Start der I2C bertragung. Erst SDA dann SCL Low
		public void I2C_Start()
		{
			SDA(0);
			SCL(0);
		}
		
		// Stoppen der I2C bertragung durch SDA dann SCL High
		public void I2C_Stop()
		{
			SDA(1);
			SCL(1);
		}

		// Acknowledge -> Byte wurde empfangen weiter Daten senden
		public void I2C_Ack()
		{
			SDA(0);
			SCL(1);
			SCL(0);
		}
		
		// No Ack -> Byte empfangen - Nichts senden
		public void I2C_NoAck()
		{
			SDA(1);
			SCL(1);
			SCL(0);
		}
		
		// Slave adressieren
		public bool I2C_Slave(byte Addr)
		{
			byte BytePos = 128;
				
		    // Die 8 Bits der Slaveadresse werden nacheinander auf die SDA-Leitung gelegt und
		    // jeweils mit einem Impuls auf der SCL-Leitung besttigt.
		    // nach dem Stop-Befehl quittiert der Slave den Empfang der Daten
				
			for (int count = 0; count < 8; count++)
			{
				if ((Addr & BytePos) == 0)
				{	SDA(0); 	}
				else
				{	SDA(1);		}
				
				SCL(1);
				SCL(0);
				BytePos /= 2;
			}
			
			// SDA auf High Pegel setzen. Slave zieht auf Masse
			SDA(1);
			// 9. Impuls
			SCL(1);
			
			// Der Slave antwortet darauf mit neg. Flanke an SDA
			if (SDA_in())
			{	
				SCL(0);
				throw new Exception("Kein Slave mit Addr. " + Addr + " vorhanden.");
			}
			else
			{	
				SCL(0);
				return true;
			}
		}

		// Werte von Slave auslesen
		// Master sendet dazu 8 Impulse auf SCL und erhlt high und low Pegel auf SDA.
		public byte I2C_in()
		{
			byte BytePos = 128;
			byte Wert = 0;
			SDA(1);
			
			for (int count = 0; count < 8; count++)
			{
				SCL(1);
				if (SDA_in()) Wert += BytePos;
				SCL(0);
				BytePos /= 2;
			}
			
			return Wert;
		}
		
		// Wert zu Slave senden
		public bool I2C_Out(byte Wert)
		{
			// Die Datenbits werden nacheinander auf SDA gelegt und mit SCL besttigt
			// nach dem neunten Impuls quittierung durch Slave
			
			byte BytePos = 128;
			
			for (int count = 0; count < 8; count++)
			{
				if ((Wert & BytePos) == 0)
				{	SDA(0);	}
				else
				{	SDA(1); }
				
				SCL(1);
				SCL(0);
				BytePos /= 2;
			}
			
			SDA(1);
			SCL(1);
			
			// Slave antwortet mit neg. Flanke auf Daten
			if ( SDA_in() )
			{
				SCL(0);
				throw new Exception("Kein Ack von Slave");
			}
			else
			{
				SCL(0);
				return true;
			}
		}
	}
}
