package i2cserial::base;

#Implementation of I2C-Protocol for
#Bitbang serial Interfaces (Horter,Elector...)
#Perl by (C) Thomas Dreler 2006
#V0.1 02.09.2006

use lib "../";


use strict;
use warnings;
use Time::HiRes qw (usleep);

#load pin assigments functions
use i2cserial::horter;
use i2cserial::log qw(:DEFAULT $errorstr);

use constant False=>0;
use constant True=>1;
use constant lf=>"\n";

    BEGIN {
        use Exporter   ();
        our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

        # set the version for version checking
        $VERSION     = 0.01;
        # if using RCS/CVS, this may be preferred
        #$VERSION = sprintf "%d.%03d", q$Revision: 1.1 $ =~ /(\d+)/g;

        @ISA         = qw(Exporter);
        @EXPORT      = qw(&i2cDelay &i2cOpen &i2cClose &i2cInit &i2cStart &i2cStop
  												&i2cAck &i2cNoAck &i2cReset &i2cIn &i2cSlave &i2cOut);
        %EXPORT_TAGS = ( );     # eg: TAG => [ qw!name1 name2! ],

        # your exported package globals go here,
        # as well as any optionally exported functions
        @EXPORT_OK   = qw($i2c_error $i2c_Port);
            }   our @EXPORT_OK;

    # exported package globals go here
    
		our  $i2c_error;
		our $i2c_Port;

    # non-exported package globals go here
    #our $interface;
    our $i2c_is_open;
    
    # initialize package globals, first exported ones
    
	  $i2c_error=False;
	  $i2c_Port='COM1';
	  $i2c_is_open=False;
	  

    # then the others (which are still accessible as $Some::Module::stuff)
    

    # all file-scoped lexicals must be created before
    # the functions below that use them.

    # file-private lexicals go here
    

    # here's a file-private function as a closure,
    # callable as &$priv_func;  it cannot be prototyped.
    
    # make all your functions, whether exported or not;
    # remember to put something interesting in the {} stubs
    #sub func1      {}    # no prototype
    #sub func2()    {}    # proto'd void
    #sub func3($$)  {}    # proto'd to 2 scalars
        # this one isn't exported, but could be called!
    #sub func4(\%)  {}    # proto'd to 1 hash ref



		
		


sub i2cDelay {
	my $us=shift;
	usleep($us);
}

		
#set default state
sub i2cInit {
	debug_log("I2CInit".lf);
	$errorstr='';
#default SDA=high and SCL=high
	SDA (True);
	SCL (True);
}

#send start sequence
sub i2cStart {
	debug_log("I2CStart".lf);
	#if CLK high ist, switch SDA from high to low
  #START => SDA=low , next SCL=low
	SDA (True);
	SCL (True);
	SDA (False);
	SCL (False);
}

#send stop sequence
sub i2cStop {
	debug_log("I2CStop".lf);
#STOP => SDA=high, next SCL=high
	SDA (False);
	SDA (True);
	SCL (True);
}


# send Ack
sub i2cAck {
	debug_log ("I2CAck".lf);
#ACKNOWLEDGE => Byte received, send more
	SDA (False);
	SCL (True);
	SCL (False);
	SDA (True);
}

#send no Ack
sub i2cNoAck {
	debug_log("I2CNoAck".lf);
#NO ACKNOWLEDGE => Byte received - Dont send more
	SDA (True);
	SCL (True);
	SCL (False);
}

#send break
sub i2cReset {
	i2cNoAck;
	i2cStop;
	i2cInit;
	i2cStart;
	i2cNoAck;
	i2cStop;
}

sub i2cOpen {
	my $Port=shift;
	$i2c_Port=$Port if ($Port);
	#$interface=shift;
	my $error=True;
	my $r;
	$r=DeviceOpen($i2c_Port);
	if ($r) {
		i2cReset;
		$error=False;
		$i2c_is_open=True;
	}
	return ! $error;
}

sub i2cClose {
	DeviceClose;
	$i2c_is_open=False;
}

#set address
sub i2cSlave {
	my $Address=shift;
#set Slave address
#same as i2cout
	debug_log( "I2CSlave:".$Address.lf);
	my $r=i2cOut($Address);
	return $r;
}

#get one byte
sub i2cIn {
	$i2c_error=False;
	debug_log ("I2CIn:");
 #Read byte from Slave
# Master givs 8 pulses to the SCL-line and will get the Bits
# (high- or low)from SDA back. This starts with MSB.
#
	my $Bit = 128;	
	my $Wert = 0;
	SDA (True);
	for (my $n = 1;$n< 9;$n++) {
	    SCL (True); #pos pulse
	    my $r=GetSDA;
	    if ($r) {
		$Wert = $Wert + $Bit;
		debug_log( "1");
	    } else {
		debug_log("0");
	    }
	    SCL (False); #neg pulse
	    $Bit = $Bit >>1;
	}
	debug_log( "->$Wert".lf);
	return $Wert;
}

#send one byte
sub i2cOut {
	my $Wert=shift;
	$i2c_error=False;
	debug_log( "I2COut".lf);

# data bits will be shift out to SDA and Ack with 9. pulse of SCL
# Slave has to Ack the Byte with SDA low

	debug_log( "Wert: $Wert," ."-->");
	$i2c_error=False;
	my $Bit = 128;
	my $r;
#send out 8 Bits
	for (my $n = 1;$n<9;$n++) {
#mask Byte with actual bit, MSB first
		if (($Wert & $Bit)==$Bit) {
			debug_log( "1");
			SDA (True);
		} else {
			debug_log( "0");
			SDA (False);
		} #Send
		SCL (True); #pos pulse
		SCL (False); #neg pulse
		$Bit = $Bit >>1;
	}
	debug_log (lf);
# 9. pulse
	
	SDA (True); #SDA high to see answer
	SCL (True); #pos pulse
	

# Slave answer with neg. Flanke
	$r=GetSDA;
	debug_log( "   SDA:".($r?'Set':'unset').lf);
	if ($r) {
	#no answer , Client should set SDA low
 		debug_log( "keine Quittierung der Daten vom Device ".lf);
 		error_txt( "keine Quittierung der Daten vom Device ".lf);
 		$i2c_error=True;
	}

	SCL (False); #neg Impuls
	return ! $i2c_error;
}
END { i2cClose; }       # module clean-up code here (global destructor)
1;