#!/usr/bin/perl

use lib ".";
use strict;
use i2cserial::log qw($debug $errorstr);
use i2cserial::base qw(:DEFAULT $i2c_error);
use i2cserial::lm75;

die "Usage: perl test_lm75.pl <Port> <Address> [<1>(Debugflag)]\n" if ($#ARGV < 1) ;
my $adresse=$ARGV[1];
my $port=$ARGV[0];
$debug=$ARGV[2];
if (i2cOpen($port)) {
    my $temp=LM75_getTemp($adresse);
    if (! $i2c_error) {
        printf ("%4.2f",$temp);
    }else {
        print "LM75Error:$errorstr";
    }
    print "\n";
} else {
    print "LM75b $errorstr\n";
}



