<?
/*
Defines for Horter&Kalb Serial Interface
www.horter.de
PHP by (C) Thomas Dreler 2006
V0.3 02.09.2006
*/

if (!extension_loaded('port')) {
		trigger_error ("IOPort Extension (php_ioport.dll) not loaded!",E_USER_ERROR);
		die;
}
$PortState=false;
$SCLState=false;

//open port
function opencom($port){
	$param=':1200,N,8,1';
	$param=$port.$param;
	$r=port_opencom($param);
	$PortState=$r;
	return $r;
}
//close port
function closecom ($port) {
	port_closecom();
	$PortState=false;
}

//set delay
function i2cdelay($ms) {
	port_delayus($ms);
}

//set SCL
function SCL($i) {
	global $SCLState;
//SCL is assigned to RTS-Line on COMx
port_rts ($i);
$SCLstate=$i;
}

//set SDA
function SDA($i) {
//SDA is assigned to DTR-Line on COMx
port_dtr($i);
}

//read SDA
Function GetSDA() {
//SDA will be read out on DSR-Line of COMx
 	return port_dsr();
}

//read INT
Function GetINT() {
//INT will be checked on CTS-Line of COMx
	  return port_cts() ;
}
//read SCL
Function GetSCL(){
	global $SCLState;
//this value is faked;the last noticed output will be returned
return $SCLState;
}

//check, if Device available
function DeviceCheck() {
	debug_log("DeviceCheck".lf);
	$error=false;
	SDA (True);
	SCL (True);
	If (GetSDA()==0) {
		debug_log ("No Answer from I2C-Interface".lf);
		error_txt ("No Answer from I2C-Interface".lf);
		$error=true;
	}
	return !$error;

}


?>
