<?
/*
Implementation of I2C-Protocol for
Bitbang serial Interfaces (Horter,Elector,cctools...)
using Port.DLL with php_ioport.dll extension
by (C) Thomas Dreler 2006
V0.3 03.09.2006
*/
//load pin assigments functions
include ("horter_seriell.php");

//debug functions
define('lf',"<br>\n");
function debug_log ($text) {
	global $debug;
	if ($debug) {print $text;}
}
function error_txt ($text) {
	global $errtext;
	$errtext.=$text;
}


//open Interface
function i2cOpen($port) {
	debug_log( "I2COpen".lf);
	$error=false;
	if (!opencom($port)){
		debug_log ("Cannot open $port".lf);
		error_txt ("Cannot open $port".lf);
		 $error=true;
	} else {
		$error=DeviceCheck;
	}
	return !$error;
}
//Interface close
function i2cClose($port) {
	debug_log("I2CClose".lf);
	closecom($port);
}

//set default state
function i2cInit() {
	debug_log("I2CInit".lf);
//default SDA=high and SCL=high
	SDA (True);
	SCL (True);
}

//send start sequence
function i2cStart() {
	debug_log("I2CStart".lf);
	// if CLK high ist, switch SDA from high to low
//START => SDA=low , next SCL=low
SDA (True);
SCL (True);
SDA (False);
SCL (False);
}

//send stop sequence
Function i2cStop() {
	debug_log("I2CStop".lf);
//STOP => SDA=high, next SCL=high
SDA (false);
SDA (True);
SCL (True);
}

//send break
Function i2cReset() {
	i2cNoAck();
	i2cStop();
	i2cInit();
	i2cStart();
	i2cNoAck();
	i2cStop();
}

//send Ack
Function i2cAck() {
	debug_log ("I2CAck".lf);
//ACKNOWLEDGE => Byte received, send more
SDA (false);
SCL (true);
SCL (false);
SDA (true);
}

//send no Ack
Function i2cNoAck() {
	debug_log("I2CNoAck".lf);
//NO ACKNOWLEDGE => Byte received - Dont send more
SDA (true);
SCL (true);
SCL (false);
}

//set address
Function i2cSlave($Adresse) {
//set Slave address
//same as i2cout
debug_log( "I2CSlave:".$Adresse.lf);
$r=i2cOut($Adresse);
return $r;
}

//get one byte
Function i2cIn() {
	debug_log ("I2CGet");
 //Read byte from Slave
/*
 Master givs 8 pulses to the SCL-line and will get the Bits
 (high- or low)from SDA back. This starts with MSB.
*/
$Bit = 128;
$Wert = 0;
SDA (true);
debug_log( "Get: ");
For ($n = 1;$n< 9;$n++) {
   SCL (true); //pos pulse
   $r=GetSDA();
   If ($r==1) {
   	$Wert = $Wert + $Bit;
   	debug_log( "1");
   } else {
   	debug_log("0");
   }
   SCL (false); //neg pulse
   $Bit = $Bit / 2;
}
debug_log( "->$Wert".lf);
return $Wert;
}

//send one byte
function i2cOut($Wert){
	debug_log( "I2COut".lf);
/*
 data bits will be shift out to SDA and Ack with 9. pulse of SCL
 Slave has to Ack the Byte with SDA low
*/
debug_log( "Wert: $Wert, ".decbin($Wert)."-->");
$error=false;
$Bit = 128;
//send out 8 Bits
For ($n = 1;$n<9;$n++) {
//mask Byte with actual bit, MSB first
If (($Wert & $Bit)==$Bit) {
	debug_log( "1");
	SDA (true);
} Else {
	debug_log( "0");
	SDA (false);
} //Send
SCL (true); //pos pulse
SCL (false); //neg pulse
$Bit = $Bit /2;
}
debug_log (lf);
// 9. Impuls
SDA (true);  //SDA high to see answer
SCL (true); //pos pulse

// Slave answer with neg. Flanke
$r=GetSDA();
debug_log( "   SDA:$r".lf);
If ($r==1) {
	//no answer , Client should set SDA low
 debug_log( "keine Quittierung der Daten vom Device ".lf);
 error_txt( "keine Quittierung der Daten vom Device ".lf);
 $error=true;
}

SCL (false); //neg Impuls
return !$error;
}

?>