<?
/*
Defines for LM75 Temperatur Sensor
PHP by (C) Thomas Dreler 2006
V0.3 02.09.2006
*/

/*
LM75 operations
Register=0 Temperatur
Register=2 Schaltpunkt
Register=3 Hysterese
*/
define ('LM75_Temp',0);
define ('LM75_Conf',1);
define ('LM75_SP',2);
define ('LM75_Hyst',3);
Function i2cLM75_in() { 
//Liest einen Wert (2 Byte) vom LM75 Temperatursensor
    debug_log ("i2cLM75In".lf); ;
    $Byte1 = i2cIn();                 //1. Byte Wert vom LM75 lesen
    i2cAck();
    $Byte2 = i2cIn();                 //2. Byte lesen
    i2cNoAck();
        
    If (($Byte1 & 128) == 0) {
        $Wert = $Byte1;              //Temperatur Vorkomma >= 0C
    }Else{
        $Wert = $Byte1 - 255;        //Temperatur Vorkomma < 0C
    }
      
    If (($Byte2 & 128) <> 0) {
        $Wert = $Wert + 0.5;
    }
    debug_log( "IN:$Byte1: $Byte2 -->$Wert".lf);
    return $Wert;

}

Function i2cLM75_out($Wert) {
//'Schreibt einen Wert (2 Byte) vom LM75 Temperatursensor


$VK = floor($wert);
$NK = $wert- $VK;

If ($VK >= 0) {
    i2cOut ($VK);
}else {
    i2cOut (255 + $VK);
}

If ($NK >= 0.5) {                     //Nachkommawert schreiben
    i2cOut (128);                          // xx,5 schreiben
}Else{
    i2cOut (0);                            // xx,0 schreiben
}

}

function LM75_Read($Adresse,$register)   {
//Werte vom LM75 lesen

i2cInit();
i2cStart();
If (i2cSlave($Adresse)){
  	i2cOut ($register); //Register auf Temperatur setzen
  	i2cStop();
  	i2cStart();
  	i2cSlave ($Adresse + 1); //Bus-Adresse des LM75 schreiben
		$temperatur = i2cLM75_in();                  //Temperatur auslesen
		debug_log("Register:".$register."->".sprintf ("%4.2f C",$temperatur).lf);
		return $temperatur;
	}
	i2cAck();
	i2cStop();
}
	
function LM75_getTemp($adresse){ 
	//Temperatur vom LM75 lesen
  $Temp = LM75_Read($adresse,LM75_Temp);
  printf("%4.2f C",$Temp);
	return $Temp;
}



function LM75_getHyst($adresse){ 
	//Hysterese vom LM75 lesen
  $Temp = LM75_Read($adresse,LM75_Hyst);
  printf("%4.2f C",$Temp);
	return $Temp;
}


Function LM75_getSP($adresse) {
	//Schaltpunkt vom LM75 lesen
	$Temp = LM75_Read($adresse,LM75_SP);
  printf("%4.2f C",$Temp);
	return $Temp;
}

function LM75_getConf($adresse) {
//Konfiguration vom LM75 lesen
i2cInit();
i2cStart();
If (i2cSlave($adresse)) {
  i2cOut (LM75_Conf);                               //Register auf "Config" setzen
  i2cStop();
  i2cStart();
  i2cSlave ($adresse + 1); //Bus-Adresse des LM75 schreiben
  $config = i2cIn();            //Konfigurationsbyte lesen
}
i2cAck();
i2cStop();
}

function LM75_Write($adresse,$register,$value) {
//Werte am LM75 setzen

i2cInit();
i2cStart();
If (i2cSlave($adresse)) {
  i2cOut ($register);      
  i2cLM75_out ($value);
}
i2cStop();
}
Function LM75_setHyst($adresse,$value) {
 //Schaltpunkt am LM75 setzen
	LM75_Write($adresse,LM75_Hyst,$value);
}



Function LM75_setSP($adresse,$value) {
 //Schaltpunkt am LM75 setzen
	LM75_Write($adresse,LM75_SP,$value);
}

Function LM75_setConf($adresse,$value) {
 //Schaltpunkt am LM75 setzen
	LM75_Write($adresse,LM75_Conf,$value);
}
?>