using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;

namespace Rs232Koppler {
    public partial class FormRs232Kopper : Form {
        private SerialI2CAdapter serialI2C;

        public FormRs232Kopper() {
            InitializeComponent();
            serialI2C = new SerialI2CAdapter();
        }

        private void FormRs232Kopper_Load(object sender, EventArgs e) {
            foreach (string s in SerialPort.GetPortNames()) {
                comboBoxComPort.Items.Add(s);
            }
            comboBoxComPort.SelectedItem = "COM1";
            comboBoxBaudRate.SelectedItem = "9600";
        }

        private void FormRs232Kopper_FormClosed(object sender, FormClosedEventArgs e) {
            if (serialI2C.IsPortOpen) {
                serialI2C.ClosePort();
            }
        }

        private void buttonOpen_Click(object sender, EventArgs e) {
            if (serialI2C.IsPortOpen) {
                serialI2C.ClosePort();
                buttonOpen.Text = "Open";
            } else {
                String port = (String)comboBoxComPort.SelectedItem;
                int baud = Convert.ToInt32(comboBoxBaudRate.SelectedItem);
                bool res = serialI2C.OpenPort(port, baud);
                if (res) {
                    buttonOpen.Text = "Close";
                    checkBoxSCL.Checked = false;
                    checkBoxSDA.Checked = false;
                }
            }
        }

        private void checkBoxSDA_CheckedChanged(object sender, EventArgs e) {
            serialI2C.SDA = checkBoxSDA.Checked;
        }

        private void checkBoxSCL_CheckedChanged(object sender, EventArgs e) {
            serialI2C.SCL = checkBoxSCL.Checked;
        }

        private void buttonReadINT_Click(object sender, EventArgs e) {
            checkBoxReadINT.Checked = serialI2C.INT;
        }

        private void buttonReadSDA_Click(object sender, EventArgs e) {
            checkBoxReadSDA.Checked = serialI2C.SDA;
        }


     }
}