using System;
using System.Collections.Generic;
using System.Text;
using System.IO.Ports;

namespace Rs232Koppler {
    /// <summary>
    /// Eine Klasse die den Zugriff auf den Rs232-I2C der Firma Horter & Kalb
    /// (www.horter.de) ermglicht. Sie entspricht dem Excel VB Funktionstest.
    /// Fr Serial Kommunikation wurde die die System.IO.Ports.SerialPort Klasse
    /// verwendet.
    /// 
    /// Author: Jens Zech (jzech@gmx.de)
    /// </summary>
    class SerialI2CAdapter {
        private SerialPort port;

        //-- Attributes -------------------------------------------------------------
        #region Attributes
        /// <summary>
        /// I2C Datenleitung an DTR Leitung der RS-232 schalten / auslesen
        /// </summary>
        public bool SDA {
            get {
                if (port == null) return false;
                return port.DsrHolding; 
            }
            set {
                if (port != null) port.DtrEnable = value; 
            }
        }
        /// <summary>
        /// I2C Taktleitung an RTS Leitung der RS-232 schalten
        /// </summary>
        public bool SCL {
            set {
                if (port != null) port.RtsEnable = value;
            }
        }
        /// <summary>
        /// Auslesen des INT am CTS der RS-232
        /// </summary>
        public bool INT {
            get {
                if (port == null) return false;
                return port.CtsHolding; 
            }
        }
        /// <summary>
        /// Prfen ob der SerialPort geffnet ist
        /// </summary>
        public bool IsPortOpen {
            get {
                if (port == null) return false;
                return port.IsOpen;
            }
        }
        #endregion

        //---------------------------------------------------------------------------
        
        /// <summary>
        /// ffnet den angegebenen SerialPort
        /// </summary>
        /// <param name="PortString">Der zu ffnende SerialPort (z.B.: COM1)</param>
        /// <param name="bautRate">die zu verwendene Baudrate (z.B.: 9600)</param>
        /// <returns>true, wenn der Port erfolgreich geffnet werden konnte</returns>
        public bool OpenPort(String PortString, int bautRate) {
            try {
                port = new SerialPort(PortString, bautRate, Parity.None, 8, StopBits.One);
                port.Open();

                return port.IsOpen;
            } catch {
                return false;
            }
        }
        
        /// <summary>
        /// Schliesst den Serialport wieder.
        /// </summary>
        public void ClosePort() {
            if (port.IsOpen)
                port.Close();
        }
    }
}
